*	See Gibbs estimation of microstructure models: Teaching notes
	November, 2006
	Joel Hasbrouck
____________________________________________________________________________________________________

	RollGibbs 2-trade case.sas

____________________________________________________________________________________________________;

*	Modify the following statement to set current directory to location of program;
x 'cd c:\Active\Mkt Microstructure Book\Programs Fall 2006';
options nodate nocenter nonumber ps=70 ls=120  sasautos=('./Sas Macros','.') mprint; 
libname SASData '.\Datasets';
libname this '.';

/*ods pdf file='./RollGibbs 01.pdf' style=serifPrinter;*/

%let Infinity=1e30;
%let eps=1e-30;

*___________________________________________________________________________________________________

	Generate some price data
____________________________________________________________________________________________________;
%let nObs=2;
%let sdu = 1;
%let c = .5;
data sim;
	p = 1; output;
	p = 1.8; output;
	run;

%let nSweeps=10000;

*___________________________________________________________________________________________________

	Simulate parameters and q's
____________________________________________________________________________________________________;
%RollGibbs(sim, nSweeps=&nSweeps, varuDraw=0, regDraw=0, cStart=&c, varuStart=%sysevalf(&sdu*&sdu));

*___________________________________________________________________________________________________

	Analyze the simulated estimates
____________________________________________________________________________________________________;
%let nDrop = 0;
data qOut2;
	set qOut;
	if sweep>&nDrop then output;
	run;
proc transpose data=qOut2 out=qt prefix=q;
	var q;
	by sweep;
	run;
data states;
	set qt;
	length outcome $ 12;
	outcome = "q1=" || put(q1,2.) || " q2=" || put(q2,2.);
	run;
proc tabulate data=states noseps;
	class q1 q2 outcome;
	table (n pctn),(q1 q2);
	table outcome all,(n*f=comma8. pctn*f=8.1);
	run;

proc means data=qt (drop=sweep) noprint;
	output out=qtMeans (drop=_type_ _freq_) mean= ;
	run;
proc transpose data=qtMeans out=qMeans (rename=(col1=q));
	run;
data qMeans;
	set qMeans;
	t = _n_;
	keep t q;
	run;
proc print data=qMeans;
	run;
